# -*- coding:utf8-*-
"""
联盟搜索
  @pageNo	Number	必须	第几页，默认1
  @pageSize	Number	必须	每页条数， 默认20，范围值1~100
  @keyWords	String	必须	查询词
  @sort	String	非必须	排序指标：销量（total_sales），淘客佣金比率（tk_rate）， 累计推广量（tk_total_sales），总支出佣金（tk_total_commi），价格（price）,排序方式：排序_des（降序），排序_asc（升序）,示例：升序查询销量：total_sales_asc
  @source	Number	非必须	是否商城商品，设置为1表示该商品是属于淘宝商城商品，设置为非1或不设置表示不判断这个属性（和overseas字段冲突，若已请求source，请勿再请求overseas）
  @overseas	Number	非必须	是否海外商品，设置为1表示该商品是属于海外商品，设置为非1或不设置表示不判断这个属性（和source字段冲突，若已请求overseas，请勿再请求source）
  @endPrice	Number	非必须	折扣价范围上限，单位：元
  @startPrice	Number	非必须	折扣价范围下限，单位：元
  @startTkRate	Number	非必须	媒体淘客佣金比率下限，如：1234表示12.34%
  @endTkRate	Number	非必须	商品筛选-淘客佣金比率上限，如：1234表示12.34%
  @hasCoupon	Boolean	非必须	是否有优惠券，设置为true表示该商品有优惠券，设置为false或不设置表示不判断这个属性
  @specialId	string	非必须	会员运营id
  @channelId	string	非必须	渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的channelId对应联盟的relationId
  @itemLoc	string	非必须	商品所在地，默认为全部商品，其他值：北京、上海、广州等必须是城市名称，不能带省份(2021/1/15新增字段)
  @needPrepay	string	非必须	商品是否加入消费者保障，1为加入消费者保障，默认全部(2021/1/15新增字段)
  @includeGoodRate	string	非必须	商品好评率是否高于行业均值，1为高于行业均值，默认全部(2021/1/15新增字段)

"""
from dtkApi.apiRequest import Request


class TbServiceReq(Request):
    url = 'tb-service/get-tb-service'
    check_params = ['pageNo','pageSize','keyWords']

    # GET请求
    def getResponse(self):
        if self.check_args(self.params, self.check_params):
            return self.request('GET', api_url=self.url, args=self.params)

    def setParams(self, pageNo, pageSize, keyWords, sort=None, source=None, overseas=None, endPrice=None,
                  startPrice=None, startTkRate=None, endTkRate=None, hasCoupon=None, specialId=None, channelId=None,
                  itemLoc=None, needPrepay=None, includeGoodRate=None):
        self.addParams('pageNo', pageNo)
        self.addParams('pageSize', pageSize)
        self.addParams('keyWords', keyWords)
        self.addParams('sort', sort)
        self.addParams('source', source)
        self.addParams('overseas', overseas)
        self.addParams('endPrice', endPrice)
        self.addParams('startPrice', startPrice)
        self.addParams('startTkRate', startTkRate)
        self.addParams('endTkRate', endTkRate)
        self.addParams('hasCoupon', hasCoupon)
        self.addParams('specialId', specialId)
        self.addParams('channelId', channelId)
        self.addParams('itemLoc', itemLoc)
        self.addParams('needPrepay', needPrepay)
        self.addParams('includeGoodRate', includeGoodRate)